<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="row justify-content-center">
            <div class="col-xl-12">
                <!-- card -->
                <div class="card card-h-100">
                    <!-- card body -->
                    <div class="card-body">
                        <div class="d-flex flex-wrap align-items-center mb-4">
                            <h5 class="card-title me-2">Detail Draft Surat</h5>
                            <div class="ms-auto">
                                <a href="<?php echo e(route('verifikator.download-preview', $surat->id)); ?>"
                                    class="btn btn-primary btn-sm">Unduh
                                    Draft Surat</a>
                                <a href="<?php echo e(route('persetujuan.show-surat', $surat->id)); ?>"
                                    class="btn btn-secondary btn-sm">Tampilkan
                                    Surat</a>
                            </div>
                        </div>

                        <div class="row align-items-center">
                            <div class="col-sm-3 text-center">
                                <img src="<?php echo e(asset('assets/images/icon/word.png')); ?>" width="auto">
                            </div>
                            <div class="col-sm align-self-center">
                                <div class="mt-4 mt-sm-0">
                                    <p class="mb-1 fw-bold">Nomor Dokumen</p>
                                    <h4><?php echo e($surat->NomorSurat); ?></h4>
                                    <div class="row g-0">
                                        <div class="col-2">
                                            <div>
                                                <p class="mb-2 text-muted text-uppercase font-size-11">Drafter</p>
                                                <h5 class="fw-medium"><?php echo e($surat->getPenulis->name); ?></h5>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div>
                                                <p class="mb-2 text-muted text-uppercase font-size-11">Penerima Surat</p>
                                                <h5 class="fw-medium"><?php echo e($surat->getPenerima->name); ?></h5>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div>
                                                <p class="mb-2 text-muted text-uppercase font-size-11">Carbon Copy</p>
                                                <h5 class="fw-medium">
                                                    <?php $__currentLoopData = $surat->CC; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penerima): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="badge bg-primary"><?php echo e($penerima->name); ?></span>,
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </h5>
                                            </div>
                                        </div>
                                        <?php if($surat->CarbonCC != null): ?>
                                            <div class="col-4">
                                                <div>
                                                    <p class="mb-2 text-muted text-uppercase font-size-11">Blind Carbon Copy</p>
                                                    <h5 class="fw-medium">
                                                        <?php $__currentLoopData = $surat->CarbonCC; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carbon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <span class="badge bg-primary"><?php echo e($carbon->name); ?></span>,
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </h5>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                    </div>
                                    <div class="col-12 mt-3">
                                        <div>
                                            <label class="mb-2 text-muted text-uppercase font-size-11">Lampiran</label>
                                            <div class="fw-medium">
                                                <?php if(count($surat->FileLampiran) < 1): ?>
                                                    <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show"
                                                        role="alert">
                                                        <i class="mdi mdi-information label-icon"></i><strong>Tidak ada
                                                            lampiran.</strong>
                                                    </div>
                                                <?php else: ?>
                                                    <?php $__currentLoopData = $surat->FileLampiran; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lampiran): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show"
                                                            role="alert">
                                                            <i class="mdi mdi-file-document label-icon"></i><strong><a
                                                                    href="<?php echo e(asset('storage/lampiran/' . $lampiran)); ?>">
                                                                    <?php echo e($lampiran); ?></strong></a>

                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="mt-2">
                                    <div class="alert alert-warning alert-dismissible alert-label-icon label-arrow fade show"
                                        role="alert">
                                        <i class="mdi mdi-check-all label-icon"></i><strong>Catatan</strong> - Catatan
                                        Verfikator
                                    </div>
                                    <?php echo $surat->getCatatan->Catatan ?? 'Tidak ada catatan'; ?>

                                </div>
                            </div>
                        </div>
                        <div class="row text-end">
                            <div class="col-md-12">
                                <div class="">
                                    <a href="javascript:void(0);"
                                        onclick="confirmApproval('<?php echo e(route('persetujuan.approve', $surat->id)); ?>')"
                                        class="btn btn-success">
                                        <i class="mdi mdi-check-circle"></i> Setujui dan Kirim ke Penerima
                                    </a>

                                    <a href="<?php echo e(route('persetujuan.reject', $surat->id)); ?>" class="btn btn-danger"><i
                                            class="mdi mdi-close-circle"></i> Tolak</a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>


        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        function confirmApproval(approveUrl) {
            Swal.fire({
                title: "Konfirmasi Persetujuan",
                text: "Apakah Anda yakin ingin menyetujui dan mengirim surat ini?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#28a745",
                cancelButtonColor: "#d33",
                confirmButtonText: "Ya, Setujui!",
                cancelButtonText: "Batal"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = approveUrl;
                }
            });
        }
    </script>
    <script>
        function previewFiles(input) {
            const previewContainer = document.getElementById('preview-container');
            previewContainer.innerHTML = ''; // Clear previous previews

            Array.from(input.files).forEach(file => {
                const reader = new FileReader();
                const previewElement = document.createElement('div');
                previewElement.className = 'preview-item position-relative';

                reader.onload = function (e) {
                    if (file.type.startsWith('image/')) {
                        previewElement.innerHTML = `
                                                                                                                                                                                                <img src="${e.target.result}" style="max-width: 150px; max-height: 150px; object-fit: cover;">
                                                                                                                                                                                                <div class="mt-1">${file.name}</div>
                                                                                                                                                                                            `;
                    } else {
                        let fileIcon = '📄';
                        if (file.type.includes('pdf')) fileIcon = '📕';
                        else if (file.type.includes('word')) fileIcon = '📘';
                        else if (file.type.includes('excel') || file.type.includes('sheet')) fileIcon = '📗';

                        previewElement.innerHTML = `
                                                                                                                                                                                                <div class="text-center">
                                                                                                                                                                                                    <div style="font-size: 2rem;">${fileIcon}</div>
                                                                                                                                                                                                    <div style="word-break: break-word; max-width: 150px;">${file.name}</div>
                                                                                                                                                                                                </div>
                                                                                                                                                                                            `;
                    }
                };

                if (file.type.startsWith('image/')) {
                    reader.readAsDataURL(file);
                } else {
                    reader.readAsText(file);
                }

                previewContainer.appendChild(previewElement);
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\SuratNew\resources\views/persetujuan/show.blade.php ENDPATH**/ ?>